---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-メール通知（HTML - デフォルト）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし。全主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Email/default/notification/body.html.twig`（デフォルトテンプレート、1行）
- E-02: `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.html.twig`（Zurb 2テンプレート、67行）
- E-03: `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php`（NotificationEmailクラス、281行）
- E-04: `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/local.css`（通知固有CSS、20行）
- E-05: `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/content_markdown.html.twig`（Markdownテンプレート、1行）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトテーマはZurb 2テーマを継承している | E-01 行1 `{% extends '@email/zurb_2/notification/body.html.twig' %}` | ○ |
| C-02 | NotificationEmailのthemeプロパティのデフォルト値がdefault | E-03 行32 `private string $theme = 'default'` | ○ |
| C-03 | getHtmlTemplate()で@email/{theme}/notification/body.html.twigを返す | E-03 行168-175 | ○ |
| C-04 | importance変数のデフォルト値がlow | E-03 行34 `'importance' => self::IMPORTANCE_LOW` | ○ |
| C-05 | footer_textのデフォルト値がNotification email sent by Symfony | E-03 行41 `'footer_text' => 'Notification email sent by Symfony'` | ○ |
| C-06 | markAsPublic()でimportanceとfooter_textがnullになる | E-03 行78-83 `$this->context['importance'] = null; $this->context['footer_text'] = null` | ○ |
| C-07 | urgentでbody_alert、highでbody_warning、それ以外でbody_default | E-02 行14 `body_{{ ('urgent' == importance ? 'alert' : ('high' == importance ? 'warning' : 'default')) }}` | ○ |
| C-08 | body_alertの色が#ec5840（赤） | E-04 行10 `border-top: 8px solid #ec5840` | ○ |
| C-09 | body_warningの色が#ffae00（黄） | E-04 行14 `border-top: 8px solid #ffae00` | ○ |
| C-10 | body_defaultの色が#aaaaaa（グレー） | E-04 行18 `border-top: 8px solid #aaaaaa` | ○ |
| C-11 | Markdown時にcontent_markdown.html.twigを使用する | E-02 行27 `{{ include('@email/zurb_2/notification/content_markdown.html.twig') }}` | ○ |
| C-12 | content_markdown.html.twigでmarkdown_to_htmlフィルタを使用する | E-05 行1 `{{ content\|markdown_to_html }}` | ○ |
| C-13 | raw時にcontent\|rawで出力する | E-02 行29 `{{ raw ? content\|raw : content\|nl2br }}` | ○ |
| C-14 | action_url指定時にボタンを表示する | E-02 行34-37 `{% if action_url %}...<button href="{{ action_url }}">` | ○ |
| C-15 | exception時にスタックトレース添付通知を表示する | E-02 行41-44 `{% if exception %}...Exception stack trace attached.` | ○ |
| C-16 | inky_to_htmlとinline_cssフィルタを使用する | E-02 行1 `{% apply inky_to_html\|inline_css %}` | ○ |
| C-17 | CssInlinerExtensionとInkyExtensionの存在をコンストラクタで検証する | E-03 行48-57 | ○ |
| C-18 | 関連機能としてNotifier（41）、Mailer（40）、Mime（42）、Twig Bridge（36） | E-06 行134-137 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトテーマとZurb 2テーマの継承関係が正確か確認
- [ ] テンプレート変数のデフォルト値がNotificationEmail.phpと一致するか確認
- [ ] 重要度に応じたスタイル切替の説明が正確か確認
